//
//  BICreateInvoiceWindow.h
//  BIViews
//
//  Created by Eric Hochmeister on 05/05/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCHelpController.h>
#import "BIAbstractCreateInvoiceEstimate.h"

@class BIInvoice;
@class BIClient;
@class BIProject;
@class BIRecurringInvoice;
@class BITableView;
@class BIProFormaInvoice;
@class BISlipsDNDArrayController;

@interface BICreateInvoiceWindow : BIAbstractCreateInvoiceEstimate {

	BIClient* client;
	BIProject* project;	
	NSArray* allSlipsDicts;
	
	BIRecurringInvoice *recurringInvoice;
	NSArray* recurringSlips;
	
	id _delegate;
	SEL _didEndSelector;
	
    BOOL applyRetainer;
	NSNumber* retainerAmountToApply;
	
	BOOL isRecurring;
	
	IBOutlet NSTextField* _numSlipsMarkedInvoicedString; 
    IBOutlet NSTextField* retainerAmountField;
	
	IBOutlet BITableView* slipsTV;
	IBOutlet BISlipsDNDArrayController* slipsAC;

	IBOutlet NSPopUpButton* _termsPopUpButton;
	int termsCode;
	
	IBOutlet NSPopUpButton* invoiceKindPopupButton;
	IBOutlet NSButton* createButton;
	int invoiceKind;
	int operatingMode;
	
	BIProFormaInvoice *currentProFormaInvoice;
}

- (void)setupInvoiceForProject:(BIProject*)aProject withSlips:(NSArray*)theSlips;
- (void)setupInvoiceForClient:(BIClient*)aClient withSlips:(NSArray*)theSlips;
- (void)setupInvoiceWithRecurringInvoice:(BIRecurringInvoice*)aRecurringInvoice;

- (void)setupTableView;

- (NSArray *)realSlipsFromSlipTemplates:(NSArray *)slipTemplates;

- (BIRecurringInvoice *)recurringInvoice;
- (void)setRecurringInvoice:(BIRecurringInvoice *)aRecurringInvoice;
- (BIProject *)project;
- (void)setProject:(BIProject *)aProject;
- (BIClient *)client;
- (void)setClient:(BIClient *)aClient;
- (NSArray *)recurringSlips;
- (void)setRecurringSlips:(NSArray *)aRecurringSlips;
- (NSArray *)allSlipsDicts;
- (void)setAllSlipsDicts:(NSArray *)anAllSlipsDicts;
- (void)updateAllSlipsDictsAndIncludeSlips:(NSArray *)slipsToInclude;
- (void)updateAllSlipsDicts;
- (NSArray *)slips;
- (IBAction)includedSlipsChanged:(id)sender;
- (void)updateSlipsCount;
- (void)updateInvoiceSlips;

- (void)setupInvoiceForClient:(BIClient*)aClient 
					 withSlips:(NSArray*)theSlips 								 
					  delegate:(id)aDelegate
				didEndSelector:(SEL)aSelector;

- (void)setupInvoiceForProject:(BIProject*)aProject 
			  withSlips:(NSArray*)theSlips 								 
			   delegate:(id)aDelegate
		 didEndSelector:(SEL)aSelector;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;
- (SEL)didEndSelector;
- (void)setDidEndSelector:(SEL)aDidEndSelector;

- (int)termsCode;
- (void)setTermsCode:(int)aCode;
- (IBAction)specifyTerms:(id)sender;
- (IBAction)updateDueDate:(id)sender;
- (IBAction)changeDueDate:(id)sender;

- (IBAction)invoiceKindChanged:(id)sender;

- (BOOL)applyRetainer;
- (void)setApplyRetainer:(BOOL)flag;

- (NSNumber*)retainerAmountToApply;
- (void)setRetainerAmountToApply:(NSNumber*)anAmount;
- (BOOL)validateRetainerAmountToApply:(id *)ioValue error:(NSError **)outError;
- (NSNumber*)maxRetainerAmountToApply;

- (void)updateRetainer;
- (void)updateDueDate;

- (BIInvoice*)invoice;

- (int)invoiceKind;
- (void)setInvoiceKind:(int)aKind;
- (void)validateButtons;

- (BIProFormaInvoice *)currentProFormaInvoice;
- (void)setupFromProFormaInvoice:(BIProFormaInvoice *)anInv;
- (void)sendProFormaObject;

// used for allClients vs. regular projects mode
- (void)setOperatingMode:(int)aMode;
- (int)operatingMode;

@end
